<?php
// auth_check.php
include 'config.php';

// Verificar si el usuario está logueado
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header("Location: auth/login.php");
    exit();
}

// Verificar timeout de sesión (8 horas)
$session_timeout = 8 * 60 * 60; // 8 horas en segundos
if (isset($_SESSION['login_time']) && (time() - $_SESSION['login_time'] > $session_timeout)) {
    session_destroy();
    header("Location: auth/login.php?timeout=1");
    exit();
}

// Verificar que los datos de sesión sean consistentes
$required_session_vars = ['user_id', 'user_name', 'user_email', 'user_type', 'login_time'];
foreach ($required_session_vars as $var) {
    if (!isset($_SESSION[$var])) {
        session_destroy();
        header("Location: auth/login.php?error=session");
        exit();
    }
}

// Actualizar última conexión periódicamente (cada 5 minutos)
if (!isset($_SESSION['last_activity']) || (time() - $_SESSION['last_activity'] > 300)) {
    $database = new Database();
    $db = $database->getConnection();
    
    $query = "UPDATE usuarios SET ultima_conexion = NOW() WHERE id = :user_id";
    $stmt = $db->prepare($query);
    $stmt->bindParam(':user_id', $_SESSION['user_id']);
    $stmt->execute();
    
    $_SESSION['last_activity'] = time();
}

// Regenerar ID de sesión periódicamente para prevenir fixation
if (!isset($_SESSION['regenerated']) || (time() - $_SESSION['regenerated'] > 1800)) {
    session_regenerate_id(true);
    $_SESSION['regenerated'] = time();
}
?>