<?php
// dashboard/index.php
include '../auth_check.php';
include '../config.php';

$database = new Database();
$db = $database->getConnection();

// Obtener datos actualizados del usuario
$user_query = "SELECT * FROM usuarios WHERE id = :user_id";
$user_stmt = $db->prepare($user_query);
$user_stmt->bindParam(':user_id', $_SESSION['user_id']);
$user_stmt->execute();
$user_data = $user_stmt->fetch(PDO::FETCH_ASSOC);

// Actualizar datos de sesión
$_SESSION['user_balance'] = $user_data['saldo'];
$_SESSION['user_trips'] = $user_data['total_viajes'];
$_SESSION['user_contacts'] = $user_data['total_contactos'];

// Obtener notificaciones no leídas
$notif_query = "SELECT COUNT(*) as count FROM notificaciones WHERE usuario_id = :user_id AND leida = 0";
$notif_stmt = $db->prepare($notif_query);
$notif_stmt->bindParam(':user_id', $_SESSION['user_id']);
$notif_stmt->execute();
$unread_notifications = $notif_stmt->fetch(PDO::FETCH_ASSOC)['count'];
?>
<!DOCTYPE html>
<html>
<head>
   <meta charset="UTF-8">
   <meta name="viewport" content="width=device-width, initial-scale=1">
   <meta name="theme-color" content="#0b1822">
   <meta http-equiv="X-UA-Compatible" content="IE=edge">
   <title>TreyNov - Dashboard</title>
   <link rel="manifest" href="manifest.json">
   <link rel="stylesheet" href="../assets/css/__1.css">
   <link rel="stylesheet" href="../assets/css/small.css">
   <link rel="shortcut icon" type="image/x-icon" href="../assets/img/icon.png">
   <style>
        .notification-badge {
            position: absolute;
            top: -5px;
            right: -5px;
            background: #ff4444;
            color: white;
            border-radius: 50%;
            width: 18px;
            height: 18px;
            font-size: 10px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
        }
        .nav_right {
            position: relative;
            display: flex;
            align-items: center;
            gap: 15px;
        }
        .balance-display {
            color: white;
            font-weight: bold;
            background: rgba(255,255,255,0.1);
            padding: 5px 10px;
            border-radius: 15px;
            font-size: 14px;
        }
   </style>
</head>
<body>
   <!-- Pasar datos del usuario a JavaScript -->
   <script>
      const userData = {
         id: <?php echo $_SESSION['user_id']; ?>,
         name: "<?php echo $_SESSION['user_name']; ?>",
         email: "<?php echo $_SESSION['user_email']; ?>",
         balance: <?php echo $_SESSION['user_balance']; ?>,
         trips: <?php echo $_SESSION['user_trips']; ?>,
         contacts: <?php echo $_SESSION['user_contacts']; ?>,
         rating: <?php echo $_SESSION['user_rating']; ?>,
         type: "<?php echo $_SESSION['user_type']; ?>"
      };
      const apiBaseUrl = '../api';
   </script>

   <div class="lader">
      <div class="nav">
         <div class="nav_left">
            <ion-icon name="menu" onclick="showMenu()"></ion-icon>
            <p>TreyNov</p>
         </div>
         <div class="nav_right">
            <span class="balance-display">S/. <?php echo number_format($_SESSION['user_balance'], 2); ?></span>
            <div style="position: relative;">
               <ion-icon name="notifications" onclick="showNotification()"></ion-icon>
               <?php if ($unread_notifications > 0): ?>
               <span class="notification-badge"><?php echo $unread_notifications; ?></span>
               <?php endif; ?>
            </div>
            <ion-icon name="share-social" onclick="showShare()"></ion-icon>
         </div>
      </div>
      <div class="dashboard">
         <div class="pr_nav">
            <h3>Listo para viajar <?php echo $_SESSION['user_name']; ?>?</h3>
            <hr>
            <div class="alerts">
               <ion-icon name="warning-outline"></ion-icon>
               <p>Los viajes no son muy seguros y recomiendamos agregar contactos de familiares.</p>
            </div>
         </div>
         <div class="statics">
            <div class="statics_data">
               <ion-icon name="car-sport-outline"></ion-icon>
               <div class="statics_text">
                  <h4>Viajes</h4>
                  <p><?php echo $_SESSION['user_trips']; ?></p>
               </div>
            </div>
            <div class="statics_data">
               <ion-icon name="call-outline"></ion-icon>
               <div class="statics_text">
                  <h4>Contactos</h4>
                  <p><?php echo $_SESSION['user_contacts']; ?>/10</p>
               </div>
            </div>
            <div class="statics_data">
               <ion-icon name="wallet-outline"></ion-icon>
               <div class="statics_text">
                  <h4>Saldo</h4>
                  <p>S/.<?php echo number_format($_SESSION['user_balance'], 2); ?></p>
               </div>
            </div>
         </div>
      </div>
   </div>

   <!-- Menu Overlay -->
   <div class="menu_overlay" id="menu_overlay" onclick="closeMenu()"></div>
   
   <!-- Menu Lateral -->
   <div class="menu" id="menu">
      <div class="menu_profile">
         <div style="display: flex; align-items: center">
            <img src="../assets/img/icon.png">
         </div>
         <div class="menu_profile_info">
            <h3><?php echo $_SESSION['user_name']; ?></h3>
            <p>Online</p>
            <div class="star_date">
               <div class="star">
                  <?php echo generateStarsHTML($_SESSION['user_rating']); ?>
               </div>
               <h3><?php echo $_SESSION['user_rating']; ?> (<?php echo $_SESSION['user_trips']; ?> reseñas)</h3>
            </div>
         </div>
      </div>
      <div class="menu_options">
         <div class="menu_option" onclick="window.location.reload()">
            <ion-icon name="home-outline"></ion-icon>
            <p>Inicio</p>
         </div>
         <div class="menu_option" onclick="showSpBot()">
            <ion-icon name="headset-outline"></ion-icon>
            <p>Soporte Bot</p>
         </div>
         <div class="menu_option" onclick="showSponline()">
            <h5>Nuevo</h5>
            <ion-icon name="chatbox-ellipses"></ion-icon>
            <p>Soporte online</p>
         </div>
         <?php if ($_SESSION['user_type'] === 'conductor'): ?>
         <div class="menu_option" onclick="window.location.href='../conductor/index.php'">
            <ion-icon name="car-sport-outline"></ion-icon>
            <p>Panel Conductor</p>
         </div>
         <?php else: ?>
         <div class="menu_option" onclick="window.location.href='../conductor/registro.php'">
            <ion-icon name="car-sport-outline"></ion-icon>
            <p>Ser Conductor</p>
         </div>
         <?php endif; ?>
         <div class="menu_option" onclick="showProfile()">
            <ion-icon name="person-outline"></ion-icon>
            <p>Perfil</p>
         </div>
         <div class="menu_option" onclick="showSettings()">
            <ion-icon name="settings-outline"></ion-icon>
            <p>Ajustes</p>
         </div>
         <div class="menu_option" onclick="showPolice()">
            <ion-icon name="shield-checkmark-outline"></ion-icon>
            <p>Política y Privacidad</p>
         </div>
         <div class="menu_option" onclick="logout()">
            <ion-icon name="log-out-outline"></ion-icon>
            <p>Cerrar sesión</p>
         </div>
      </div>
   </div>

   <!-- Contenido Principal -->
   <div class="app">
      <div class="filter">
         <div class="filter_left">
            <ion-icon name="location"></ion-icon>
            <p><b id="locatio_data_user_mobile_pais">...</b> > <b id="locatio_data_user_mobile_departamento">...</b> > <b id="locatio_data_user_mobile_locale">...</b></p>
         </div>
         <div class="filter_right">
            <div class="btn_tipe">
               <div class="btn_tipe_by" onclick="tipePrivate()">
                  <ion-icon name="person"></ion-icon>
                  <p>Privado</p>
               </div>
               <div class="btn_tipe_by" onclick="tipeGrupo()">
                  <ion-icon name="people"></ion-icon>
                  <p>Grupo</p>
               </div>
               <div class="indicator_btn"></div>
            </div>
            <div class="chat_live">
               <span>6</span>
               <ion-icon name="chatbubble-ellipses-outline"></ion-icon>
            </div>
         </div>
      </div>
      
      <!-- Conductores -->
      <div id="candado"></div>
      <div id="publica"></div>
   </div>

   <!-- Secciones Modales -->
   <div class="section notifications">
      <div class="section_nav">
         <div class="section_nav_left">
            <ion-icon name="arrow-back" onclick="closeNotification()"></ion-icon>
            <p>Notificaciones</p>
         </div>
      </div>
      <div class="section_content">
         <div id="notificationsList">
            <!-- Las notificaciones se cargarán aquí -->
         </div>
      </div>
   </div>

   <!-- Configuración -->
   <div class="section settings">
      <div class="section_nav">
         <div class="section_nav_left">
            <ion-icon name="arrow-back" onclick="closeSettings()"></ion-icon>
            <p>Configuración</p>
         </div>
      </div>
      <div class="section_content sett">
         <div class="card_get">
            <div class="card_get_nav">
               <h3>Notificaciones</h3>
            </div>
            <div class="card_get_content">
               <div class="get_option">
                  <p>Notificationes Push</p>
                  <button class="toggle" id="t-notif" aria-pressed="false" aria-label="Interruptor Notificaciones"></button>
               </div>
               <div class="get_option">
                  <p>Promociones</p>
                  <button class="toggle" id="t-promotion" aria-pressed="false" aria-label="Interruptor Notificaciones"></button>
               </div>
               <div class="get_option">
                  <p>Alertas</p>
                  <button class="toggle" id="t-alerts" aria-pressed="false" aria-label="Interruptor Notificaciones"></button>
               </div>
            </div>
         </div>
         <br>
         <div class="card_get">
            <div class="card_get_nav">
               <h3>Cuenta y acceso</h3>
            </div>
            <div class="card_get_content">
               <div class="get_option">
                  <p>Metodo de 2 factores</p>
                  <button class="toggle" id="t-factory" aria-pressed="false" aria-label="f2t"></button>
               </div>
               <div class="get_option">
                  <p>Voletin informativo</p>
                  <button class="toggle" id="t-vf" aria-pressed="false" aria-label="vf"></button>
               </div>
               <div class="get_option">
                  <p>Eliminar cuenta</p>
                  <ion-icon name="chevron-forward" style="padding:8px;font-size: 1.4em"></ion-icon>
               </div>
            </div>
         </div>
         <br>
         <div class="card_get">
            <div class="card_get_nav">
               <h3>Configuración de pagos aceptables</h3>
            </div>
            <div class="card_get_content">
               <div class="get_option">
                  <p>Yape</p>
                  <button class="toggle" id="t-yape" aria-pressed="false" aria-label="yape"></button>
               </div>
               <div class="get_option">
                  <p>Plin</p>
                  <button class="toggle" id="t-plin" aria-pressed="false" aria-label="Plin"></button>
               </div>
               <div class="get_option">
                  <p>Efectivo (cash)</p>
                  <button class="toggle" id="t-efective" aria-pressed="false" aria-label="efective"></button>
               </div>
               <div class="get_option">
                  <p>Transferencia Bancaria</p>
                  <button class="toggle" id="t-bank" aria-pressed="false" aria-label="Bank"></button>
               </div>
            </div>
         </div>
      </div>
   </div>

   <!-- Soporte Bot -->
   <div class="section soporte_bot">
      <div class="section_nav">
         <div class="section_nav_left">
            <ion-icon name="arrow-back" onclick="closeSpbot()"></ion-icon>
            <p>Soporte (IA)</p>
         </div>
      </div>
      <div class="section_content chat">
         <br>
         <div class="chat_online">
            <div class="chat_online_person">
               <h4>Aymel (IA)<div class="bulb_online"></div></h4>
               <p>Hola querido <?php echo $_SESSION['user_name']; ?>, ¿cómo podemos ayudarte a organizarte mejor?</p>
               <br>
               <span><?php echo date('d/m/Y'); ?></span>
            </div>
         </div>
         <br>
         <div class="chat_send">
            <div class="send_input">
               <input type="text" placeholder="Escribenos aqui..." id="chatInput">
            </div>
            <div class="btn_send" onclick="sendChatMessage()">
               <ion-icon name="send"></ion-icon>
            </div>
         </div>
      </div>
   </div>

   <!-- Perfil -->
   <div class="section profile">
      <div class="section_nav">
         <div class="section_nav_left">
            <ion-icon name="arrow-back" onclick="closeProfile()"></ion-icon>
            <p>Perfil</p>
         </div>
      </div>
      <div class="section_content">
         <div class="card_get">
            <div class="card_get_nav">
               <h3>Información Personal</h3>
            </div>
            <div class="card_get_content">
               <div class="get_option">
                  <p>Nombre</p>
                  <p><strong><?php echo $_SESSION['user_name']; ?></strong></p>
               </div>
               <div class="get_option">
                  <p>Email</p>
                  <p><strong><?php echo $_SESSION['user_email']; ?></strong></p>
               </div>
               <div class="get_option">
                  <p>Teléfono</p>
                  <p><strong><?php echo $_SESSION['user_phone']; ?></strong></p>
               </div>
               <div class="get_option">
                  <p>Tipo de cuenta</p>
                  <p><strong><?php echo ucfirst($_SESSION['user_type']); ?></strong></p>
               </div>
            </div>
         </div>
         <br>
         <div class="card_get">
            <div class="card_get_nav">
               <h3>Estadísticas</h3>
            </div>
            <div class="card_get_content">
               <div class="get_option">
                  <p>Viajes realizados</p>
                  <p><strong><?php echo $_SESSION['user_trips']; ?></strong></p>
               </div>
               <div class="get_option">
                  <p>Rating</p>
                  <p><strong><?php echo $_SESSION['user_rating']; ?> ⭐</strong></p>
               </div>
               <div class="get_option">
                  <p>Contactos de emergencia</p>
                  <p><strong><?php echo $_SESSION['user_contacts']; ?>/10</strong></p>
               </div>
            </div>
         </div>
      </div>
   </div>

   <!-- Políticas -->
   <div class="section politicas">
      <div class="section_nav">
         <div class="section_nav_left">
            <ion-icon name="arrow-back" onclick="closePolice()"></ion-icon>
            <p>Política y Privacidad</p>
         </div>
      </div>
      <div class="section_content police_place">
         <!-- Contenido de políticas (igual que antes) -->
      </div>
   </div>

   <!-- Alertas de sistema -->
   <div class="map_alert" id="map_alert">
      <div class="map_alert_content">
         <h4>Maps locale</h4>
         <p id="map_text">...</p>
         <div class="map_btn" onclick="activarUbicacion()">
            <p>Activar</p>
         </div>
      </div>
   </div>
   
   <div class="internet" id="Internet">
      <div class="internet_content">
         <h3>Alerta</h3>
         <p>Estas sin <b>Internet</b> ,conectate a una red WiFi para continuar.</p>
      </div>
   </div>

   <script src="../assets/js/__1.js"></script>
   <script src="app.js"></script>
   <script type="module" src="https://unpkg.com/ionicons@7.1.0/dist/ionicons/ionicons.esm.js"></script>
   <script nomodule src="https://unpkg.com/ionicons@7.1.0/dist/ionicons/ionicons.js"></script>
</body>
</html>

<?php
function generateStarsHTML($rating) {
    $stars = '';
    $fullStars = floor($rating);
    $hasHalfStar = ($rating - $fullStars) >= 0.5;
    
    for ($i = 0; $i < $fullStars; $i++) {
        $stars .= '<ion-icon name="star"></ion-icon>';
    }
    
    if ($hasHalfStar) {
        $stars .= '<ion-icon name="star-half"></ion-icon>';
    }
    
    $emptyStars = 5 - $fullStars - ($hasHalfStar ? 1 : 0);
    for ($i = 0; $i < $emptyStars; $i++) {
        $stars .= '<ion-icon name="star-outline"></ion-icon>';
    }
    
    return $stars;
}
?>